/*
    MOFINO, ver. 2.1.  (C) Ramon P. Garcia    Feb 2014- May, 2015.
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details (http://www.gnu.org/licenses/)
*/
#include <Wire.h>
#include <stdio.h>
#include <stdlib.h>  
#include "LCD.h"
//LiquidDisplay library. (C) F. Malpartida, 2011 - Under creative commons license 3.0: attribution-ShareAlike CC BY-SA 
#include "LiquidCrystal_SR.h"
//MenuBackend library - (C) A. Brevig
#include <MenuBackend.h> 
#include <EEPROM.h>
#define address 0
#ifndef cbi
#define cbi(sfr, bit)     (_SFR_BYTE(sfr) &= ~_BV(bit))
#endif
#ifndef sbi
#define sbi(sfr, bit)     (_SFR_BYTE(sfr) |= _BV(bit))
#endif
#define LTC_CS 2         // LTC2400 Chip Select Pin  on Portb 2
#define LTC_MISO  4      // LTC2400 SDO Select Pin  on Portb 4
#define LTC_SCK  5       // LTC2400 SCK Select Pin  on Portb 5
#define PIN_RL1 14
#define PIN_RL2 17
#define PIN_RL3 18
#define PIN_RL4 16
#define PIN_RL5 15
#define PIN_RL6 19
LiquidCrystal_SR lcd(9, 8, 7);
const int buttonPinLeft = 2;      
const int buttonPinRight = 3;    
const int buttonPinEsc = 4;     
const int buttonPinEnter = 5;   
int lastButtonPushed = 0;
int lastButtonEnterState = LOW;   
int lastButtonEscState = LOW;  
int lastButtonLeftState = LOW;   
int lastButtonRightState = LOW;   
long lastEnterDebounceTime = 0;  
long lastEscDebounceTime = 0;  
long lastLeftDebounceTime = 0;  
long lastRightDebounceTime = 0;  
long debounceDelay = 500;    
struct DATOS{
   float   offset;
   float   Bcal_AC;
   float    Coef_k_AC;
   int N;
   float R;
   int tipo_resistencia;
   int ref_externa;
   boolean usable;
};
union MEMORIA{
   DATOS dato;
   byte  b[sizeof(DATOS)];
}
miMemoria;
float volt;
float v_ref=5.000;          // Reference Voltage.  (IC REF195E)
long int ltw = 0;        
int cnt;                  
byte b0;                  
byte sig;                 
char st1[20];             
float offset=miMemoria.dato.offset;
float campo_calibrac_AC=miMemoria.dato.Bcal_AC;
int comprobarcalibra=0;
char junk = ' ';
const int c=41; // Number max. measures
float readings[c];      
int index = 0;                  
float average = 0;               
float total = 0; 
// MenuBackend  menu (C) G. Di Cillo (www.coagula.org)
MenuBackend menu = MenuBackend(menuUsed,menuChanged);
MenuItem menu1Item1 = MenuItem("Item1");   
MenuItem menuItem11 = MenuItem("Item11");
MenuItem menuItem12 = MenuItem("Item12");
MenuItem menu1Item2 = MenuItem("Item2");
MenuItem menuItem21 = MenuItem("Item21");
MenuItem menuItem22 = MenuItem("Item22");
MenuItem menu1Item3 = MenuItem("Item3");
MenuItem menuItem31 = MenuItem("Item31");
MenuItem menuItem32 = MenuItem("Item32");
MenuItem menuItem33 = MenuItem("Item33");
MenuItem menuItem34 = MenuItem("Item34"); 

void setup(){
  // Data EEPROM recover:
  for( int i=0 ; i<sizeof(DATOS) ; i++  )
    miMemoria.b[i] = EEPROM.read( address+i );
   // Checking data EEPROM reading
  if( miMemoria.dato.usable == false ){
    valoresdefecto();
    miMemoria.dato.usable = true;
  }
  pinMode(PIN_RL1, OUTPUT) ;   // Set AC/DC calibration current. OFF --> DC ; ON --> AC
  pinMode(PIN_RL2, OUTPUT) ;   // Calibration resistor
  pinMode(PIN_RL3, OUTPUT) ;   // DC current inverter
  pinMode(PIN_RL4, OUTPUT) ;   // Activate calibration current
  pinMode(PIN_RL5, OUTPUT) ;   // Reference lock-in
  pinMode(PIN_RL6, OUTPUT) ;   // Set AC/DC mode measurement 
  pinMode(buttonPinLeft, INPUT);
  pinMode(buttonPinRight, INPUT);
  pinMode(buttonPinEnter, INPUT);
  pinMode(buttonPinEsc, INPUT);
  // init SPI Hardwareconst
  cbi(PORTB,LTC_SCK);      
  sbi (DDRB,LTC_CS);       
  cbi (DDRB,LTC_MISO);
  sbi (DDRB,LTC_SCK);
  sbi(SPCR,MSTR) ; 
  sbi(SPCR,SPR0) ; 
  sbi(SPCR,SPR1);  
  sbi(SPCR,SPE);   
  Serial.begin(9600);
  lcd.begin(16, 2);
  //Setup menu
  menu.getRoot().add(menu1Item1);
  menu1Item1.addRight(menu1Item2).addRight(menu1Item3);
  menu1Item1.add(menuItem11).addRight(menuItem12);
  menu1Item2.add(menuItem21).addRight(menuItem22);
  menu1Item3.add(menuItem31).addRight(menuItem32).addRight(menuItem33).addRight(menuItem34);
  menu.toRoot();
  lcd.setCursor(0,0);  
  lcd.print("MOFINO");
   help();
}  
// Setup key option  MOFINO program
void loop(){
  readButtons();   
  navigateMenus();   
  if(Serial.available()) {
    char ch = Serial.read() ; 
  if(ch==65 || ch==97) {  //A--> Get magnetic field
   Serial.println(F("Q-QUIT"));
   medidaAC(1);
   help();
  }
  if(ch==66 || ch==98) {  //B --> Place MO material
    prepararDC();
    colocarmuestra();
    help();
  }
  if(ch==67 || ch==99) {  //C --> Set calibration resistance
    int valor;
    int tipo_resistencia=miMemoria.dato.tipo_resistencia;
    Serial.println(F("Set calibration resistance (1-EXTERNAL, 2-INTERNAL-10k)"));
    if (tipo_resistencia==2)
      Serial.println(F("INTERNAL"));
    else
      Serial.println(F("EXTERNAL"));
 // Change the calibration field. External resistance is interchangeable.
  valor=teclado();
  if (valor>0 && valor<3)
    tipo_resistencia=valor;
  help();
  miMemoria.dato.tipo_resistencia=tipo_resistencia;
  salvardatos();
  prepararAC();
 }
  if(ch==68 || ch==100) {  //D --> Set Offset
   float valor;
   float offset=miMemoria.dato.offset;
   Serial.println(F("Offset? (Q -> quit)"));
   printFloat(offset,6);           
   Serial.println();
   valor=teclado();
   offset=valor;
   help();
   miMemoria.dato.offset=offset;
   salvardatos();
 }
 if(ch==69 || ch==101) {  //E --> Set Distance to sensor
     float valor;
     float R=miMemoria.dato.R;
     Serial.println(F("Set Distance to sensor (cm) ? (Q -> QUIT)"));
     printFloat(R,1);           
     Serial.println();
     valor=teclado();
    if (valor>0.0)
      R=valor;
    help();
    miMemoria.dato.R=R;
    salvardatos();
 }
  if(ch==70 || ch==102) {  // F --> Set AC field calibration
  Serial.println(F("Set AC field calibration? (Q -> QUIT)"));
  float valor;
  float campo_calibrac_AC=miMemoria.dato.Bcal_AC;
  printFloat(campo_calibrac_AC,6);           
  Serial.println();
  valor=teclado();
  if (valor>0.0)
    campo_calibrac_AC=valor;
  help();
  miMemoria.dato.Bcal_AC=campo_calibrac_AC;
  salvardatos();
  }
  if(ch==73 || ch==105) {  //I --> Set intensity current
   Serial.println("Q- QUIT");
   medidaAC(2);
   help();
 } 
 if(ch==76|| ch==108) {  //L -> Lock-in direct measurement  
   prepararAC();
   Serial.println(F("Q-QUIT"));
   medirLTC();
   menuprincipal();
   help();
   }
 if(ch==110 || ch==78) {  //N -> Set number of measurements
   int valor;
   int N=miMemoria.dato.N;
   Serial.print(F("Set number of measures(MIN.3 - MAX. 41)? "));
   Serial.println(N); 
  valor=teclado();
  if (valor>0 && valor<42)
    N=valor;
  if (N<3)
    N=3;
  help();
  miMemoria.dato.N=N;
  salvardatos();
 } 
 if(ch==82|| ch==114) { //R --> 1: Disable external reference , 2: Enable external reference 
    int valor;
    int ref_externa=miMemoria.dato.ref_externa;
    Serial.println(F("Lock-in external reference? (1-Y, 2-N)"));
   valor=teclado();
    if (valor==1)
      Serial.println(F("Disconnect REF-INPUT"));
    else if (valor==2)
      Serial.println(F("Connect REF-INPUT"));
    if (valor>0 && valor<3)
      ref_externa=valor;
    miMemoria.dato.ref_externa=ref_externa;
    salvardatos();
    prepararAC();
    help();
  }
   if(ch==86 || ch==118) {  // V-> Voltmeter
     Serial.println(F("Q-QUIT"));
     prepararDC();
     medirLTC();
     help();
   }
   if(ch==90 || ch==122){  //Z --> Load defaults
     valoresdefecto();
     Serial.println(F("OK"));
     help();
   } 
  }
}

void menuChanged(MenuChangeEvent changed){
  MenuItem newMenuItem=changed.to; 
  lcd.setCursor(0,1); 
  if(newMenuItem.getName()==menu.getRoot()){
    lcd.print("Select option");
  }else if(newMenuItem.getName()=="Item1"){
    lcd.print(F("Measure AC      "));
    prepararAC();
  }else if(newMenuItem.getName()=="Item11"){
    lcd.print("Magnetic field");
  }else if(newMenuItem.getName()=="Item12"){
    lcd.print("Electric current ");
  }else if(newMenuItem.getName()=="Item2"){
    lcd.print("Direct measures");
  }else if(newMenuItem.getName()=="Item21"){
    lcd.clear();
    prepararDC();
    lcd.print("Voltmeter DC  ");
  }else if(newMenuItem.getName()=="Item22"){
    lcd.clear();  
    prepararAC();
    lcd.print("Lock-in  ");
  }else if(newMenuItem.getName()=="Item3"){
    lcd.print("Other functions ");
  }else if(newMenuItem.getName()=="Item31"){
    lcd.clear();
    lcd.print("Place polarizers");
    prepararDC();
  }else if(newMenuItem.getName()=="Item32"){
    lcd.clear();
    lcd.print("Check RELES ");
  }else if(newMenuItem.getName()=="Item33"){
    lcd.clear();
    lcd.print("Default");
  }else if(newMenuItem.getName()=="Item34"){
    lcd.clear();
    lcd.print("About");
  }
}

void menuUsed(MenuUseEvent used){
  lcd.clear();  
  lcd.print("Wait       ");
  if(used.item.getName()=="Item11"){
    medidaAC(1);
  }
  else if(used.item.getName()=="Item12"){
    medidaAC(2);
  }
 else if(used.item.getName()=="Item21"){
    medirLTC();
   }
   else if(used.item.getName()=="Item22"){
    // lock-in
    prepararAC();
    medirLTC();
   } 
   else   if(used.item.getName()=="Item31"){
    colocarmuestra();
  }
   else if(used.item.getName()=="Item32"){
    lcd.print("Check RELES");
    comprobarreles();
    lcd.setCursor(0,1); 
    lcd.print("Repetir");}
   else   if(used.item.getName()=="Item33"){
     valoresdefecto();  
  }
  else if(used.item.getName()=="Item34"){
  // acerca de 
    lcd.clear(); // go home
    lcd.print("MOFINO. Ver.2.1");
    lcd.setCursor(0,1);
    lcd.print("Ramon P. Garcia");
  }
  else
    lcd.print(used.item.getName());
  delay(100);  
}

 void colocarmuestra(){
  memset(readings,0,sizeof(readings)); 
  lcd.print("Place MO material");
  Serial.println(F("Q-SALIR"));
  Serial.println(F("Rotate the polarizer/s  to achieve the highest value of S"));
  Serial.println(F("v2 < v0 < v1 || v2 > v0 > v1?"));
  int i=0;
  float S;
  do {
    S=calibrarDC();
    i=i+1;
    lcd.print( "Measurement n:");
    lcd.print(i); 
    lcd.setCursor(0,1);
    lcd.print(F("S= ")); 
    lcd.print(S,2);
    Serial.print(F("S= "));
    Serial.println(S);
    lcd.setCursor(0,0);
     } while (digitalRead(buttonPinEsc)==LOW && Serial.read()!=81 && Serial.read()!=113);
  help();
  lcd.setCursor(0,0);
  lcd.clear();
  lcd.print("Repeat");
}

float leertension() {
  float leervoltaje=readVoltage();
  for (int i=0;i<2;i++){
    leervoltaje=readVoltage();
    delay(150);
  }
  return (leervoltaje);
}

void salvardatos(){
  for( int i=0 ; i<sizeof(DATOS) ; i++  )
    EEPROM.write( address+i , miMemoria.b[i] );
    delay(150);
}

float calcularcampoAC(float k,float a){
  float v=leertension();
  float I=k*v-a;
  return( I);
}

float calibrarDC() {  
  // Set Calibration  Coil
  digitalWrite(PIN_RL4, HIGH) ;
  delay(2000);
  float v1=leertension();   
  digitalWrite(PIN_RL4, LOW) ;
  delay(500);
  // Change current direction
  digitalWrite(PIN_RL3, HIGH) ;
  delay(500);
  //Disable calibration coil
  digitalWrite(PIN_RL4, HIGH) ;
  delay(2000);
  float v2=leertension();
  //Disable calibration coil
  digitalWrite(PIN_RL4, LOW) ;
  delay(500);
  digitalWrite(PIN_RL3, LOW) ;
  delay(2000);
  // Zero field measurement
  float v0=leertension();
  Serial.print(v1,6);
  Serial.print("  ");
  Serial.print(v2,6);
  Serial.print("  ");
  Serial.print(v0,6);
  if ((( v0<v1)&&(v0>v2))|| (( v0>v1)&&(v0<v2)))
    Serial.println( F("  ->OK"));
  else
    Serial.println( F(" ->NO"));
  float S=1000*abs(v2-v1);
  lcd.begin(16,2);
  lcd.clear();
  return S;
}

float calibrarAC(float B) {
  digitalWrite(PIN_RL1, HIGH) ;
  delay(5000);
  float v2=leertension();
  v2=leertension();
  digitalWrite(PIN_RL1, LOW) ;
  delay(6000);
  float v1=leertension();
  v1=leertension();
  float coef_k_AC=B/(v2-v1);
  return  coef_k_AC; 
}

 float comprobarreles() {  
  digitalWrite(PIN_RL1, HIGH) ;
  delay(500);
  digitalWrite(PIN_RL1, LOW) ;
  delay(500);
  digitalWrite(PIN_RL2, HIGH) ;
  delay(500);
  digitalWrite(PIN_RL2, LOW) ;
  delay(500);
  digitalWrite(PIN_RL3, HIGH) ;
  delay(500);
  digitalWrite(PIN_RL3, LOW) ;
  delay(500);
  digitalWrite(PIN_RL4, HIGH) ;
  delay(500);
  digitalWrite(PIN_RL4, LOW) ;
  delay(500);
  digitalWrite(PIN_RL5, HIGH) ;
  delay(500);
  digitalWrite(PIN_RL5, LOW) ;
  delay(500);
  digitalWrite(PIN_RL6, HIGH) ;
  delay(500);
  digitalWrite(PIN_RL6, LOW) ;
  delay(500);
  }
  
  void prepararDC(){
  lcd.print("DC measurement ");
   // Disable AC circuit
   digitalWrite(PIN_RL1, LOW) ;
  delay(150);
  // Disable external output reference
   digitalWrite(PIN_RL5, LOW) ;
   delay(150);
   digitalWrite(PIN_RL6, LOW) ;
   delay(500);
}

void prepararAC() {
  // Enable internal reference?
  if (miMemoria.dato.ref_externa==2){
    digitalWrite(PIN_RL5, HIGH) ;
  }else{
    digitalWrite(PIN_RL5, LOW) ;
  } 
 delay(150);
  // Enable AC reading
  digitalWrite(PIN_RL6, HIGH) ;
  delay(500);
  int  tiporesistencia=miMemoria.dato.tipo_resistencia;
  if (tiporesistencia==1)
    digitalWrite(PIN_RL2, HIGH) ;
   else
     digitalWrite(PIN_RL2, LOW) ;
  delay(500);
}
 
void medidaAC(int tipo){
  prepararAC();
  lcd.clear(); // go home
  lcd.print ("AC measurement ");
  memset(readings,0,sizeof(readings)); 
  int i=0;
  float campo_calibrac_AC=miMemoria.dato.Bcal_AC;
  float offset=miMemoria.dato.offset;
   float k;
  float B_AC;
  k=calibrarAC(campo_calibrac_AC);
  do {
    lcd.begin(16,2);
    lcd.setCursor(0,1);
    k=calibrarAC(campo_calibrac_AC);
    Serial.print("k= ");
    Serial.print(k);
    Serial.println(" V/G");
    B_AC=calcularcampoAC(k,offset);
    Serial.print("B(");
    Serial.print(i,1);
    Serial.print(")= ");
    Serial.print(B_AC,2);
    Serial.println(" G");
    readings[i] =B_AC;
    lcd.setCursor(0,1);
    lcd.print( "B(G)=");
    lcd.print(B_AC,6); 
    lcd.setCursor(0,0);
    i=i+1;
    lcd.print( "Measurement ");
    lcd.print(i);              
    } while (digitalRead(buttonPinEsc)==LOW && Serial.read()!=81 && Serial.read()!=113 && i<miMemoria.dato.N);
  lcd.setCursor(0,0);
  lcd.clear();
  lcd.print("Repetir");
  if (i==miMemoria.dato.N){
    float BmAC = media(readings); 
    if (tipo==1){
      lcd.setCursor(0,1);
      Serial.print(F("Bm= "));
      Serial.print(BmAC,3);
      Serial.println(F(" G"));
      lcd.print(F( "Bm(G)="));
     lcd.print(BmAC,3); 
    }
    if (tipo==2){
      lcd.setCursor(0,1);
      float R=miMemoria.dato.R;
      float ImAC=5*BmAC*R; //  Biot-Savart
      Serial.print(F("I="));
      Serial.print(ImAC,1);
      Serial.println(" A");
      lcd.print(F( "I(A)="));
      lcd.print(ImAC,1); 
    }
  }
}
  
float media(float vector[]){
  float total=0.;
  float media;
  int tama=miMemoria.dato.N;
  float temp;
  Serial.println("-----------"); 
  int i,j;
  for (i = 0; i < (tama - 1); i++) { 
    for (j = i + 1; j < tama; j++) { 
      if (vector[j] < vector[i]) { 
        temp = vector[j]; 
        vector[j] = vector[i]; 
        vector[i] = temp; 
      } 
    } 
 }
 for (i = 1; i < tama-1 ; i++) 
    total= total + vector[i];
 media = total /( miMemoria.dato.N-2); 
 return media; 
}

void menuprincipal(){
  lcd.setCursor(0,0);  
  lcd.print("Select     ");
  menu.toRoot();  
}

void medirLTC(){
  lcd.clear(); // go home
  float leervoltaje;
  int i=0;
  lcd.setCursor(0,0);
  lcd.print(F("Salir -> Q o ESC"));
  lcd.setCursor(0,1);
  lcd.print ("V= ");
  float total=0;
  memset(readings,0,sizeof(readings));
   do{
     leervoltaje=leertension();
     total=total+leervoltaje;
     lcd.setCursor(3,1);
     Serial.println(leervoltaje,6);
     lcd.print(leervoltaje,6);
     i=i+1;
     } while (digitalRead(buttonPinEsc)==LOW && Serial.read()!=81 && Serial.read()!=113);
  lcd.clear(); // go home
  lcd.print(F("Repeat LTC"));
  lcd.setCursor(0,1);
  lcd.print( "Vm=");
  average=total/i;
  lcd.print(average,6) ;
  lcd.print (" V");
}
float teclado(){
  float valor;
  while (Serial.available() == 0) ;  // Wait
  {
       valor= Serial.parseFloat();        
        while (Serial.available() > 0)  
         { junk = Serial.read() ; }      // Clean keyboard buffer
   }
   return valor;
}
void valoresdefecto(){
  lcd.clear(); // go home
  miMemoria.dato.Coef_k_AC=10;
  miMemoria.dato.N = 1;
  miMemoria.dato.R=1;
  miMemoria.dato.offset=0;
  miMemoria.dato.Bcal_AC=1;
  miMemoria.dato.tipo_resistencia=2;
  miMemoria.dato.ref_externa = 2;
  salvardatos();
  lcd.print("OK");
  lcd.setCursor(0,1);
  lcd.print("Return");
}
  //Control button menu by Giuseppe Di Cillo (www.coagula.org)
 void  readButtons(){  
  int reading;
  int buttonEnterState=LOW;            
  int buttonEscState=LOW;             
  int buttonLeftState=LOW;            
  int buttonRightState=LOW;            
  reading = digitalRead(buttonPinEnter);
  if (reading != lastButtonEnterState) {
   lastEnterDebounceTime = millis();
  } 
  if ((millis() - lastEnterDebounceTime) > debounceDelay) {
    buttonEnterState=reading;
    lastEnterDebounceTime=millis();
  }
  lastButtonEnterState = reading;
  reading = digitalRead(buttonPinEsc);
  if (reading != lastButtonEscState) {
    lastEscDebounceTime = millis();
  } 
  if ((millis() - lastEscDebounceTime) > debounceDelay) {
    buttonEscState = reading;
    lastEscDebounceTime=millis();
  }
  lastButtonEscState = reading;                                
  reading = digitalRead(buttonPinRight);
  if (reading != lastButtonRightState) {
    lastRightDebounceTime = millis();
  } 
  if ((millis() - lastRightDebounceTime) > debounceDelay) {
   buttonRightState = reading;
   lastRightDebounceTime =millis();
  }
  lastButtonRightState = reading;                  
  reading = digitalRead(buttonPinLeft);
  if (reading != lastButtonLeftState) {
   lastLeftDebounceTime = millis();
  } 
  if ((millis() - lastLeftDebounceTime) > debounceDelay) {
    buttonLeftState = reading;
    lastLeftDebounceTime=millis();;
  }
  lastButtonLeftState = reading;  
  if (buttonEnterState==HIGH){
    lastButtonPushed=buttonPinEnter;
  }else if(buttonEscState==HIGH){
    lastButtonPushed=buttonPinEsc;
  }else if(buttonRightState==HIGH){
    lastButtonPushed=buttonPinRight;
  }else if(buttonLeftState==HIGH){
    lastButtonPushed=buttonPinLeft;
  }else{
    lastButtonPushed=0;
  }                  
}

void navigateMenus() {
  MenuItem currentMenu=menu.getCurrent();
  switch (lastButtonPushed){
  case buttonPinEnter:
    if(!(currentMenu.moveDown())){  
        menu.use();
    }else{  
        menu.moveDown();
    } 
  break;
  case buttonPinEsc:
    lcd.begin(16,2);
    lcd.clear();
    menuprincipal();
    break;
  case buttonPinRight:
    menu.moveRight();
    break;      
  case buttonPinLeft:
    menu.moveLeft();
    break;      
  }
  lastButtonPushed=0; 
}
 /*
    LTC2400 24bit ADC Module: 7 digit voltmeter  By coldtears electronics
    Hardware--> 4.096V precision reference (TI REF3040) changed to 5.000V  precision reference ( IC REF195E) by Ramon P. Garcia 
    LTC2400 code is adapted from Martin Nawrath
    Kunsthochschule fuer Medien Koeln
    Academy of Media Arts Cologne
*/
float readVoltage() {
 cbi(PORTB,LTC_CS);             
 delayMicroseconds(1);
 if (!(PINB & (1 << 4))) {    
   ltw=0;
   sig=0;
   b0 = SPI_read();             
   if ((b0 & 0x20) ==0) sig=1;  
   b0 &=0x1F;                   
   ltw |= b0;
   ltw <<= 8;
   b0 = SPI_read();
   ltw |= b0;
   ltw <<= 8;
   b0 = SPI_read();
   ltw |= b0;
   ltw <<= 8;
   b0 = SPI_read();
   ltw |= b0;
   delayMicroseconds(1);
   sbi(PORTB,LTC_CS);          
   if (sig) ltw |= 0xf0000000;    
     ltw=ltw/16;                   
   volt = ltw * v_ref *4.3/ 16777216; 
   char tmp[10];
   dtostrf(volt,6,6,tmp);
   tmp[8]='V';
   tmp[9]='\n';
return (volt);
 }
 sbi(PORTB,LTC_CS); 
 delay(20);
}

byte SPI_read()
{
 SPDR = 0;
 while (!(SPSR & (1 << SPIF))) ; 
   return SPDR;
}

void printFloat(float value, int places) {
 int digit;
 float tens = 0.1;
 int tenscount = 0;
 int i;
 float tempfloat = value;
 float d = 0.5;
 if (value < 0)
   d *= -1.0;
  for (i = 0; i < places; i++)
   d/= 10.0;
   tempfloat +=  d;
 if (value < 0)
   tempfloat *= -1.0;
 while ((tens * 10.0) <= tempfloat) {
   tens *= 10.0;
   tenscount += 1;
 }
 if (value < 0)
   Serial.print('-');
 if (tenscount == 0)
   Serial.print(0, DEC);
 for (i=0; i< tenscount; i++) {
   digit = (int) (tempfloat/tens);
   Serial.print(digit, DEC);
   tempfloat = tempfloat - ((float)digit * tens);
   tens /= 10.0;
 }
 if (places <= 0)
   return;
  Serial.print('.');
 for (i = 0; i < places; i++) {
   tempfloat *= 10.0;
   digit = (int) tempfloat;
   Serial.print(digit,DEC);
   tempfloat = tempfloat - (float) digit;
 }
}

void help () {
   Serial.println (F ("=========================================== == "));
   Serial.println (F ("A - Get AC magnetic field"));
   Serial.println (F ("B - Position sample"));
   Serial.println (F ("C - Set calibration resistance"));
   Serial.println (F ("D - Set offset"));
   Serial.println (F ("E - Set Distance to sensor (cm)"));
   Serial.println (F ("F - Set AC calibration field"));
   Serial.println (F ("I - Get current intensity"));
   Serial.println (F ("L - Lock-in  direct measurement"));
   Serial.println (F ("N - Set number of measurements"));
   Serial.println (F ("R - Select lock-in reference "));
   Serial.println (F ("V - Voltmeter"));
   Serial.println (F ("Z - Default"));
   Serial.println (F ("=========================================== == "));
}
 
  
